(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    487013,      10926]
NotebookOptionsPosition[    482934,      10839]
NotebookOutlinePosition[    483322,      10856]
CellTagsIndexPosition[    483279,      10853]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\:ff31\:ff32\:30b3\:30fc\:30c9\:ff13\:578b", "Section",
 CellChangeTimes->{{3.7538284444662724`*^9, 
  3.753828516987033*^9}},ExpressionUUID->"e07f9a12-48e4-42b5-b009-\
1b0d75e66552"],

Cell[CellGroupData[{

Cell["GF(256)", "Subsection",
 InitializationCell->True,
 CellChangeTimes->{{3.753828557896137*^9, 
  3.7538285632482433`*^9}},ExpressionUUID->"b7d2c6a5-280d-436e-b356-\
17169095a4e9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\:751f\:6210\:5143", "=", 
   RowBox[{"1", "+", 
    SuperscriptBox["\[Gamma]", "2"], "+", 
    SuperscriptBox["\[Gamma]", "3"], "+", 
    SuperscriptBox["\[Gamma]", "4"], "+", 
    SuperscriptBox["\[Gamma]", "8"]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\:52a0\:6cd5\:8868\:793a", "[", "x_", "]"}], ":=", 
  RowBox[{"PolynomialMod", "[", 
   RowBox[{"x", ",", 
    RowBox[{"{", 
     RowBox[{"\:751f\:6210\:5143", ",", "2"}], "}"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"F256", "=", 
   RowBox[{"Prepend", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"\:52a0\:6cd5\:8868\:793a", "[", 
        SuperscriptBox["\[Gamma]", "k"], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "254"}], "}"}]}], "]"}], ",", "0"}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"\:4f4d\:7f6e", "[", 
    RowBox[{"L_", ",", "e_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"Position", "[", 
      RowBox[{"L", ",", "e"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"\:4e57\:6cd5\:8868\:793a", "[", "x_", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"\:4f4d\:7f6e", "[", 
       RowBox[{"F256", ",", 
        RowBox[{"\:52a0\:6cd5\:8868\:793a", "[", "x", "]"}]}], "]"}], 
      "\[NotEqual]", "1"}], ",", " ", 
     RowBox[{"\[Gamma]", "^", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\:4f4d\:7f6e", "[", 
         RowBox[{"F256", ",", 
          RowBox[{"\:52a0\:6cd5\:8868\:793a", "[", "x", "]"}]}], "]"}], "-", 
        "2"}], ")"}]}], ",", "0"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.753828875264347*^9, 3.7538288769782867`*^9}, {
   3.753841980777103*^9, 3.753842005893034*^9}, 3.753842039660975*^9, {
   3.753842283813056*^9, 3.753842285104065*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"90b69506-5311-4d64-8c37-22f9f4afe4a7"]
}, Closed]],

Cell[CellGroupData[{

Cell["RS\:7b26\:53f7", "Subsection",
 InitializationCell->True,
 CellChangeTimes->{{3.75382925939802*^9, 
  3.7538293049265127`*^9}},ExpressionUUID->"d4376af0-c42c-4048-8dd5-\
645d6268b3c6"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\:751f\:6210\:591a\:9805\:5f0f", "[", 
      RowBox[{"n_", ",", "k_"}], "]"}], " ", ":=", 
     RowBox[{"Collect", "[", 
      RowBox[{
       RowBox[{"Product", "[", 
        RowBox[{
         RowBox[{"x", "+", 
          RowBox[{"\[Gamma]", "^", "i"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "0", ",", 
           RowBox[{"n", "-", "k", "-", "1"}]}], "}"}]}], "]"}], ",", "x", ",",
        "\:4e57\:6cd5\:8868\:793a"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\:7b26\:53f7\:5316", "[", 
      RowBox[{"vector_", ",", "n_", ",", "k_"}], "]"}], ":=", 
     "\[IndentingNewLine]", 
     RowBox[{"Collect", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"PolynomialMod", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"vector", ".", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Length", "[", "vector", "]"}], "+", "n", "-", "k", 
                "-", "i"}], ")"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", 
               RowBox[{"Length", "[", "vector", "]"}]}], "}"}]}], "]"}]}], 
          "+", "\[IndentingNewLine]", 
          RowBox[{"PolynomialMod", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"vector", ".", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"x", "^", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"Length", "[", "vector", "]"}], "+", "n", "-", "k", 
                  "-", "i"}], ")"}]}], ",", 
               RowBox[{"{", 
                RowBox[{"i", ",", "1", ",", 
                 RowBox[{"Length", "[", "vector", "]"}]}], "}"}]}], "]"}]}], 
            ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"\:751f\:6210\:591a\:9805\:5f0f", "[", 
               RowBox[{"n", ",", "k"}], "]"}], ",", "2"}], "}"}]}], "]"}]}], 
         ",", "2"}], "]"}], ",", "\[IndentingNewLine]", "x", ",", 
       "\:4e57\:6cd5\:8868\:793a"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\:5fa9\:53f7", "[", "polynomial_", "]"}], ":=", 
     "\[IndentingNewLine]", 
     RowBox[{"Map", "[", 
      RowBox[{"\:4e57\:6cd5\:8868\:793a", ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"polynomial", ",", "x", ",", 
           RowBox[{"n", "-", "1", "-", "i"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "0", ",", 
           RowBox[{"k", "-", "1"}]}], "}"}]}], "]"}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.753829320509563*^9, 3.753829341190461*^9}, 
   3.7538294551864767`*^9, {3.753830361979013*^9, 3.7538303652107267`*^9}, {
   3.753830463686935*^9, 3.7538304676251698`*^9}, {3.753830555356498*^9, 
   3.753830557272941*^9}, {3.753839163063244*^9, 3.753839181689371*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"91114228-e766-405b-bc56-3bf22474f0ff"]
}, Closed]],

Cell[CellGroupData[{

Cell["Data ", "Subsection",
 InitializationCell->True,
 CellChangeTimes->{{3.753829384713773*^9, 3.753829396283124*^9}, 
   3.753829459429019*^9, {3.753831714001927*^9, 
   3.7538317155679007`*^9}},ExpressionUUID->"f3cae15e-5244-4ac7-8440-\
06abe5daf437"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"n", "=", "70"}], ";", 
    RowBox[{"k", "=", "55"}], ";", "\:30ec\:30d9\:30ebL"}], "\:3000", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"n", "=", "70"}], ";", 
    RowBox[{"k", "=", "44"}], ";", "\:30ec\:30d9\:30ebM"}], "\:3000", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"n", "=", "35"}], ";", 
    RowBox[{"k", "=", "17"}], ";", "\:30ec\:30d9\:30ebQ"}], "\:3000", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"n", "=", "35"}], ";", 
    RowBox[{"k", "=", "13"}], ";", "\:30ec\:30d9\:30ebH"}], "\:3000", "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.753830377227318*^9, 3.753830457521051*^9}, {
  3.753830518762457*^9, 3.7538305273823013`*^9}, {3.753993550792493*^9, 
  3.753993642842942*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"0302a324-1e0f-4511-940b-1cfd96afebe8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\:30e2\:30a6\:30c9", "[", "\:6570\:5b57", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}], "}"}]}], ";", 
   RowBox[{
    RowBox[{"\:30e2\:30a6\:30c9", "[", "\:82f1\:6570\:5b57", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], "}"}]}], ";", 
   RowBox[{
    RowBox[{"\:30e2\:30a6\:30c9", "[", 
     RowBox[{"8", "bit"}], "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], "}"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:30e2\:30a6\:30c9", "[", "\:6f22\:5b57", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], "}"}]}], ";", 
  RowBox[{
   RowBox[{"\:30e2\:30a6\:30c9", "[", "ECI", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "1", ",", "1"}], "}"}], "}"}]}], 
  ";"}]}], "Input",
 PageWidth->Infinity,
 InitializationCell->True,
 CellChangeTimes->{{3.753830832721871*^9, 3.753830881747653*^9}, {
   3.753830932761437*^9, 3.753830951362834*^9}, 3.7538310474289*^9, {
   3.753832240683009*^9, 3.7538322602946053`*^9}, {3.754051886400181*^9, 
   3.754051892342659*^9}, {3.783991693873382*^9, 3.783991693885437*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"6914f19c-1fae-4fac-adfa-8f5657336b0c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\:8a02\:6b63\:30ec\:30d9\:30eb", "[", "L", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}], "}"}]}], ";", 
  RowBox[{
   RowBox[{"\:8a02\:6b63\:30ec\:30d9\:30eb", "[", "M", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:8a02\:6b63\:30ec\:30d9\:30eb", "[", "Q", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "}"}]}], ";", 
  RowBox[{
   RowBox[{"\:8a02\:6b63\:30ec\:30d9\:30eb", "[", "H", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], "}"}]}], ";"}]}], "Input",
 PageWidth->Infinity,
 InitializationCell->True,
 CellChangeTimes->{{3.753831034343862*^9, 3.753831040136711*^9}, {
   3.75383228345522*^9, 3.753832314396405*^9}, 3.7538323489172297`*^9},
 CellLabel->"In[12]:=",ExpressionUUID->"8af800ad-e210-4a76-93e9-fc097df2c871"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"\:30de\:30b9\:30af", "[", "000", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}]}], ";", 
   RowBox[{
    RowBox[{"\:30de\:30b9\:30af", "[", "001", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}], "}"}]}], ";", 
   RowBox[{
    RowBox[{"\:30de\:30b9\:30af", "[", "010", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], "}"}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\:30de\:30b9\:30af", "[", "011", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1"}], "}"}], "}"}]}], ";", 
   RowBox[{
    RowBox[{"\:30de\:30b9\:30af", "[", "100", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], "}"}]}], ";", 
   RowBox[{
    RowBox[{"\:30de\:30b9\:30af", "[", "101", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1"}], "}"}], "}"}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\:30de\:30b9\:30af", "[", "110", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0"}], "}"}], "}"}]}], ";", 
   RowBox[{
    RowBox[{"\:30de\:30b9\:30af", "[", "111", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], "}"}]}], ";"}], 
  "*)"}]], "Input",
 PageWidth->Infinity,
 InitializationCell->True,
 CellChangeTimes->{{3.7538310707143297`*^9, 3.7538310842326736`*^9}, {
  3.7538322866887608`*^9, 3.753832359583527*^9}, {3.75399564821276*^9, 
  3.753995651256988*^9}, {3.754009511892418*^9, 3.754009514648945*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"ff6bb003-f28d-48f1-861c-0567caed9f01"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\:6587\:5b57\:6570", "[", 
    RowBox[{"data_", ",", "\"\<\:6570\:5b57\>\""}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"IntegerDigits", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"StringLength", "[", "data", "]"}], "+", 
        RowBox[{"2", "^", "10"}]}], ",", "2"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"2", ";;", "11"}], "]"}], "]"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"\:6587\:5b57\:6570", "[", 
    RowBox[{"data_", ",", "\"\<\:82f1\:6570\:5b57\>\""}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"IntegerDigits", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"StringLength", "[", "data", "]"}], "+", 
        RowBox[{"2", "^", "9"}]}], ",", "2"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"2", ";;", "10"}], "]"}], "]"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"\:6587\:5b57\:6570", "[", 
    RowBox[{"data_", ",", "\"\<\:6f22\:5b57\>\""}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"IntegerDigits", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"StringLength", "[", "data", "]"}], "+", 
        RowBox[{"2", "^", "8"}]}], ",", "2"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"2", ";;", "9"}], "]"}], "]"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:6587\:5b57\:6570", "[", 
    RowBox[{"data_", ",", "\"\<8 bit\>\""}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"IntegerDigits", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", 
         RowBox[{"Flatten", "[", 
          RowBox[{"Map", "[", 
           RowBox[{"f", ",", 
            RowBox[{"ToCharacterCode", "[", 
             RowBox[{"data", ",", "\"\<Unicode\>\""}], "]"}]}], "]"}], "]"}], 
         "]"}], "+", 
        RowBox[{"2", "^", "8"}]}], ",", "2"}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"2", ";;", "9"}], "]"}], "]"}], "}"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.753831243548984*^9, 3.753831301001486*^9}, 
   3.753831373475404*^9, {3.7540005892732477`*^9, 3.75400058983432*^9}, {
   3.754077446183485*^9, 3.754077461620594*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"8bcea365-3d44-4deb-b76b-3bab200fd319"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\:7d42\:7aefPattern", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:57cb\:8349Pattern", "[", "1", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", "1", ",", "0", ",", 
      "0"}], "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:57cb\:8349Pattern", "[", "2", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
      "1"}], " ", "}"}], "}"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.753831828671301*^9, 3.753831882508667*^9}, {
  3.753831921554418*^9, 3.7538319358668137`*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"2f796dc2-6250-42bd-b017-2455df9704bf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\:ff18bit\:5316", "[", "data_", "]"}], ":=", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"IntegerDigits", "[", 
       RowBox[{
        RowBox[{"#", "+", 
         RowBox[{"2", "^", "8"}]}], ",", "2"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"2", ";;", "9"}], "]"}], "]"}], "&"}], ",", "data"}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.753965125996957*^9, 3.753965192405405*^9}, {
   3.753965240249514*^9, 3.7539652439671917`*^9}, 3.7539653936216393`*^9, {
   3.75399961721198*^9, 3.75399963438445*^9}, 3.7539996920405827`*^9},
 CellLabel->"In[22]:=",ExpressionUUID->"d8dfb0e1-8e72-4cc4-90ef-49842a5cb832"]
}, Closed]],

Cell[CellGroupData[{

Cell["\:5f62\:5f0f\:60c5\:5831", "Subsection",
 InitializationCell->True,
 CellChangeTimes->{{3.753829384713773*^9, 3.753829396283124*^9}, 
   3.753829459429019*^9, {3.753831714001927*^9, 3.7538317155679007`*^9}, {
   3.754003218893153*^9, 
   3.754003223456758*^9}},ExpressionUUID->"d9fb9af3-4880-4d19-b515-\
e7c1dc524331"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\:5f62\:5f0f\:60c5\:5831", "[", 
   RowBox[{"level_", ",", "mask_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"info", ",", "encoded"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"info", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"\:8a02\:6b63\:30ec\:30d9\:30eb", "[", "level", "]"}], ",", 
         RowBox[{
          RowBox[{"IntegerDigits", "[", 
           RowBox[{"mask", "+", "1000"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"2", ";;", "4"}], "]"}], "]"}]}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"encoded", "=", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"Coefficient", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"info", ".", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"x", "^", 
                  RowBox[{"(", 
                   RowBox[{"15", "-", "i"}], ")"}]}], ",", 
                 RowBox[{"{", 
                  RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}]}], "+", 
              "\[IndentingNewLine]", 
              RowBox[{"PolynomialMod", "[", 
               RowBox[{
                RowBox[{"info", ".", 
                 RowBox[{"Table", "[", 
                  RowBox[{
                   RowBox[{"x", "^", 
                    RowBox[{"(", 
                    RowBox[{"15", "-", "i"}], ")"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}]}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   SuperscriptBox["x", "10"], "+", 
                   SuperscriptBox["x", "8"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "2"], "+", "x", "+", "1"}], ",", "2"}],
                  "}"}]}], "]"}]}], ",", "\[IndentingNewLine]", "x", ",", 
             RowBox[{"14", "-", "i"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "0", ",", "14"}], "}"}]}], "]"}], 
         "\[IndentingNewLine]", "+", 
         RowBox[{"{", 
          RowBox[{
          "1", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", 
           ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", 
           "1", ",", "0"}], "}"}]}], "\[IndentingNewLine]", ",", "2"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Normal", "[", 
      RowBox[{"SparseArray", "[", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"9", ",", "1"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"9", ",", "2"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"9", ",", "3"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"9", ",", "4"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"9", ",", "5"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "5", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"9", ",", "6"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "6", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"9", ",", "8"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "7", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"9", ",", "22"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "8", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"9", ",", "23"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "9", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"9", ",", "24"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "10", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"9", ",", "25"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "11", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"9", ",", "26"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "12", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"9", ",", "27"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "13", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"9", ",", "28"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "14", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"9", ",", "29"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "15", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"29", ",", "9"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"28", ",", "9"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"27", ",", "9"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"26", ",", "9"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"25", ",", "9"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "5", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"24", ",", "9"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "6", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"23", ",", "9"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "7", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"9", ",", "9"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "8", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"8", ",", "9"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "9", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"6", ",", "9"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "10", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"5", ",", "9"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "11", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"4", ",", "9"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "12", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"3", ",", "9"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "13", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2", ",", "9"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "14", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "9"}], "}"}], "\[Rule]", 
          RowBox[{"encoded", "[", 
           RowBox[{"[", "15", "]"}], "]"}]}]}], "\[IndentingNewLine]", "}"}], 
       "]"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.754009676652787*^9, 3.7540096985011272`*^9}, {
  3.754010571353322*^9, 3.7540105858785152`*^9}, {3.7540108378553753`*^9, 
  3.754010863805127*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"1c8ae614-29bb-427a-bbbc-b24b8dc16161"]
}, Closed]],

Cell[CellGroupData[{

Cell["\:30de\:30b9\:30af ", "Subsection",
 InitializationCell->True,
 CellChangeTimes->{{3.753829384713773*^9, 3.753829396283124*^9}, 
   3.753829459429019*^9, {3.753831714001927*^9, 3.7538317155679007`*^9}, 
   3.754003232205502*^9},ExpressionUUID->"0ffcaa2a-8f7b-4b4b-a5af-\
5998bd8d9dca"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mask", "[", 
    RowBox[{"000", ",", "i_", ",", "j_"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"i", "-", "1"}], ")"}], "+", 
         RowBox[{"(", 
          RowBox[{"j", "-", "1"}], ")"}]}], ",", "2"}], "]"}], "\[Equal]", 
      "0"}], ",", "1", ",", "0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mask", "[", 
    RowBox[{"001", ",", "i_", ",", "j_"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"i", "-", "1"}], ")"}], ",", "2"}], "]"}], "\[Equal]", "0"}],
      ",", "1", ",", "0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mask", "[", 
    RowBox[{"010", ",", "i_", ",", "j_"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"j", "-", "1"}], ")"}], ",", "3"}], "]"}], "\[Equal]", "0"}],
      ",", "1", ",", "0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mask", "[", 
    RowBox[{"011", ",", "i_", ",", "j_"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"i", "-", "1"}], ")"}], "+", 
         RowBox[{"(", 
          RowBox[{"j", "-", "1"}], ")"}]}], ",", "3"}], "]"}], "\[Equal]", 
      "0"}], ",", "1", ",", "0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mask", "[", 
    RowBox[{"100", ",", "i_", ",", "j_"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"i", "-", "1"}], ")"}], "/", "2"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"j", "-", "1"}], ")"}], "/", "3"}]}], ",", "2"}], "]"}], 
      "\[Equal]", "0"}], ",", "1", ",", "0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mask", "[", 
    RowBox[{"101", ",", "i_", ",", "j_"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"i", "-", "1"}], ")"}], 
          RowBox[{"(", 
           RowBox[{"j", "-", "1"}], ")"}]}], ",", "2"}], "]"}], "+", 
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"i", "-", "1"}], ")"}], 
          RowBox[{"(", 
           RowBox[{"j", "-", "1"}], ")"}]}], ",", "3"}], "]"}]}], "\[Equal]", 
      "0"}], ",", "1", ",", "0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mask", "[", 
    RowBox[{"110", ",", "i_", ",", "j_"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Mod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"i", "-", "1"}], ")"}], 
            RowBox[{"(", 
             RowBox[{"j", "-", "1"}], ")"}]}], ",", "2"}], "]"}], "+", 
         RowBox[{"Mod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"i", "-", "1"}], ")"}], 
            RowBox[{"(", 
             RowBox[{"j", "-", "1"}], ")"}]}], ",", "3"}], "]"}]}], ",", 
        "2"}], "]"}], "\[Equal]", "0"}], ",", "1", ",", "0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mask", "[", 
    RowBox[{"111", ",", "i_", ",", "j_"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Mod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"i", "-", "1"}], ")"}], 
            RowBox[{"(", 
             RowBox[{"j", "-", "1"}], ")"}]}], ",", "3"}], "]"}], "+", 
         RowBox[{"Mod", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"i", "-", "1"}], ")"}], "+", 
            RowBox[{"(", 
             RowBox[{"j", "-", "1"}], ")"}]}], ",", "2"}], "]"}]}], ",", 
        "2"}], "]"}], "\[Equal]", "0"}], ",", "1", ",", "0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:30de\:30b9\:30af", "[", "type_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"mask", "[", 
       RowBox[{"type", ",", "i", ",", "j"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "29"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "29"}], "}"}]}], "]"}], "*", "dataArea"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.753655816713832*^9, 3.753655842847979*^9}, {
  3.7536559230510473`*^9, 3.7536560430094557`*^9}, {3.753656236905416*^9, 
  3.7536563075794373`*^9}, {3.753656345556137*^9, 3.753656427767372*^9}, {
  3.7536564982099*^9, 3.753656577886758*^9}, {3.753656726974814*^9, 
  3.7536567386683807`*^9}, {3.753656862279195*^9, 3.753656882131114*^9}, {
  3.753729557841578*^9, 3.753729558014682*^9}, {3.754008933326686*^9, 
  3.754009047077714*^9}, {3.754009224231826*^9, 3.7540092630247593`*^9}, {
  3.7540094687839813`*^9, 3.754009490149967*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"94625f43-5b98-4da4-94c9-a84cfe6d08e4"]
}, Closed]],

Cell[CellGroupData[{

Cell["\:7b26\:53f7\:8a9e", "Subsection",
 InitializationCell->True,
 CellChangeTimes->{{3.753829384713773*^9, 3.753829396283124*^9}, 
   3.753829459429019*^9, {3.753831714001927*^9, 3.7538317155679007`*^9}, 
   3.754003232205502*^9, {3.754003379006363*^9, 3.7540033842421513`*^9}, {
   3.754003617212365*^9, 
   3.7540036270840387`*^9}},ExpressionUUID->"5483aa85-60b6-4eb8-9694-\
36c76aed6b17"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\:8aa4\:308a\:8a02\:6b63", "[", 
     RowBox[{"data_", ",", "level_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "poly", ",", "correction", ",", "part1", ",", "part2", ",", "n", ",", 
        "k"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"n", "=", 
        RowBox[{"Switch", "[", 
         RowBox[{
         "level", ",", "L", ",", "70", ",", "M", ",", "70", ",", "Q", ",", 
          "35", ",", "H", ",", "35"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"k", "=", 
        RowBox[{"Switch", "[", 
         RowBox[{
         "level", ",", "L", ",", "55", ",", "M", ",", "44", ",", "Q", ",", 
          "17", ",", "H", ",", "13"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Switch", "[", 
        RowBox[{
        "n", ",", "\[IndentingNewLine]", "70", ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"poly", "=", 
           RowBox[{
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"\:4e57\:6cd5\:8868\:793a", "[", 
                RowBox[{"#", ".", 
                 RowBox[{"Table", "[", 
                  RowBox[{
                   SuperscriptBox["\[Gamma]", 
                    RowBox[{"(", 
                    RowBox[{"7", "-", "i"}], ")"}]], ",", 
                   RowBox[{"{", 
                    RowBox[{"i", ",", "0", ",", "7"}], "}"}]}], "]"}]}], 
                "]"}], "&"}], ",", "data"}], "]"}], ".", 
            "\[IndentingNewLine]", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"n", "-", "i"}], ")"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", "1", ",", "k"}], "}"}]}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"correction", "=", 
           RowBox[{"Collect", "[", 
            RowBox[{
             RowBox[{"PolynomialMod", "[", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"poly", "+", " ", 
                RowBox[{"PolynomialRemainder", "[", 
                 RowBox[{"poly", ",", 
                  RowBox[{"PolynomialMod", "[", 
                   RowBox[{
                    RowBox[{"\:751f\:6210\:591a\:9805\:5f0f", "[", 
                    RowBox[{"n", ",", "k"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\:751f\:6210\:5143", ",", "2"}], "}"}]}], "]"}], 
                  ",", "x"}], "]"}]}], ",", "\[IndentingNewLine]", 
               RowBox[{"{", 
                RowBox[{"\:751f\:6210\:5143", ",", "2"}], "}"}]}], "]"}], ",",
              "\[IndentingNewLine]", "x"}], "]"}]}]}], ",", 
         "\[IndentingNewLine]", "35", ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"part1", "=", 
           RowBox[{
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"\:4e57\:6cd5\:8868\:793a", "[", 
                RowBox[{"#", ".", 
                 RowBox[{"Table", "[", 
                  RowBox[{
                   SuperscriptBox["\[Gamma]", 
                    RowBox[{"(", 
                    RowBox[{"7", "-", "i"}], ")"}]], ",", 
                   RowBox[{"{", 
                    RowBox[{"i", ",", "0", ",", "7"}], "}"}]}], "]"}]}], 
                "]"}], "&"}], ",", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"Partition", "[", 
                RowBox[{"data", ",", "k"}], "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ".", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"n", "-", "i"}], ")"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", "1", ",", "k"}], "}"}]}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"part2", "=", 
           RowBox[{
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"\:4e57\:6cd5\:8868\:793a", "[", 
                RowBox[{"#", ".", 
                 RowBox[{"Table", "[", 
                  RowBox[{
                   SuperscriptBox["\[Gamma]", 
                    RowBox[{"(", 
                    RowBox[{"7", "-", "i"}], ")"}]], ",", 
                   RowBox[{"{", 
                    RowBox[{"i", ",", "0", ",", "7"}], "}"}]}], "]"}]}], 
                "]"}], "&"}], ",", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"Partition", "[", 
                RowBox[{"data", ",", "k"}], "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ".", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"n", "-", "i"}], ")"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", "1", ",", "k"}], "}"}]}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"correction", "=", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Collect", "[", 
                RowBox[{
                 RowBox[{"PolynomialMod", "[", "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"part1", "+", " ", 
                    RowBox[{"PolynomialRemainder", "[", 
                    RowBox[{"part1", ",", 
                    RowBox[{"PolynomialMod", "[", 
                    RowBox[{
                    RowBox[{"\:751f\:6210\:591a\:9805\:5f0f", "[", 
                    RowBox[{"n", ",", "k"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\:751f\:6210\:5143", ",", "2"}], "}"}]}], "]"}], 
                    ",", "x"}], "]"}]}], ",", "\[IndentingNewLine]", 
                   RowBox[{"{", 
                    RowBox[{"\:751f\:6210\:5143", ",", "2"}], "}"}]}], "]"}], 
                 ",", "\[IndentingNewLine]", "x"}], "]"}], "/.", 
               RowBox[{"{", 
                RowBox[{"x", "\[Rule]", 
                 SuperscriptBox["x", "2"]}], "}"}]}], ")"}], "*", "x"}], 
            "\[IndentingNewLine]", "+", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Collect", "[", 
               RowBox[{
                RowBox[{"PolynomialMod", "[", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"part2", "+", " ", 
                   RowBox[{"PolynomialRemainder", "[", 
                    RowBox[{"part2", ",", 
                    RowBox[{"PolynomialMod", "[", 
                    RowBox[{
                    RowBox[{"\:751f\:6210\:591a\:9805\:5f0f", "[", 
                    RowBox[{"n", ",", "k"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\:751f\:6210\:5143", ",", "2"}], "}"}]}], "]"}], 
                    ",", "x"}], "]"}]}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"\:751f\:6210\:5143", ",", "2"}], "}"}]}], "]"}], 
                ",", "\[IndentingNewLine]", "x"}], "]"}], "/.", 
              RowBox[{"{", 
               RowBox[{"x", "\[Rule]", 
                SuperscriptBox["x", "2"]}], "}"}]}], ")"}]}]}], ";"}]}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{"Map", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"Coefficient", "[", 
               RowBox[{
                RowBox[{"\:52a0\:6cd5\:8868\:793a", "[", "#", "]"}], ",", 
                "\[Gamma]", ",", 
                RowBox[{"7", "-", "i"}]}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", "0", ",", "7"}], "}"}]}], "]"}], " ", "&"}], 
           ",", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"Coefficient", "[", 
              RowBox[{"correction", ",", "x", ",", 
               RowBox[{"69", "-", "i"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "0", ",", "69"}], "}"}]}], "]"}]}], "]"}], 
         ",", "2"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:7b26\:53f7\:8a9e", "[", 
    RowBox[{"input_", ",", "mode_", ",", "level_"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"dataSize", ",", "data"}], "}"}], ",", 
     RowBox[{"(*", " ", "\:4e0d\:5b8c\:5168", " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"dataSize", "=", 
       RowBox[{"Switch", "[", 
        RowBox[{
        "level", ",", "L", ",", "55", ",", "M", ",", "44", ",", "Q", ",", 
         "34", ",", "H", ",", "26"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"data", "=", 
       RowBox[{"Switch", "[", 
        RowBox[{"mode", ",", "\[IndentingNewLine]", 
         RowBox[{"8", "bit"}], ",", "\[IndentingNewLine]", 
         RowBox[{"PadRight", "[", 
          RowBox[{
           RowBox[{"Partition", "[", 
            RowBox[{
             RowBox[{"Flatten", "[", "\[IndentingNewLine]", 
              RowBox[{"Join", "[", 
               RowBox[{
                RowBox[{"\:30e2\:30a6\:30c9", "[", 
                 RowBox[{"8", "bit"}], "]"}], ",", "\[IndentingNewLine]", 
                RowBox[{"\:6587\:5b57\:6570", "[", 
                 RowBox[{"input", ",", "\"\<8 bit\>\""}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"\:ff18bit\:5316", "[", 
                 RowBox[{"ToCharacterCode", "[", 
                  RowBox[{"input", ",", "\"\<Unicode\>\""}], "]"}], "]"}], 
                ",", "\[IndentingNewLine]", "\:7d42\:7aefPattern", ",", 
                RowBox[{"{", 
                 RowBox[{
                 "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
                  "0"}], "}"}]}], "]"}], "]"}], ",", "8"}], "]"}], ",", 
           "\[IndentingNewLine]", "dataSize", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", "1", ",", "0",
                ",", "0"}], " ", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
              "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0",
                ",", "1"}], "}"}]}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", "\:6f22\:5b57", ",", "\[IndentingNewLine]", 
         RowBox[{"PadRight", "[", 
          RowBox[{
           RowBox[{"Partition", "[", 
            RowBox[{
             RowBox[{"Flatten", "[", "\[IndentingNewLine]", 
              RowBox[{"Join", "[", 
               RowBox[{
                RowBox[{"\:30e2\:30a6\:30c9", "[", "\:6f22\:5b57", "]"}], ",",
                 "\[IndentingNewLine]", 
                RowBox[{"\:6587\:5b57\:6570", "[", 
                 RowBox[{"input", ",", "\"\<\:6f22\:5b57\>\""}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"Map", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{"IntegerDigits", "[", 
                    RowBox[{
                    RowBox[{"#", "+", 
                    RowBox[{"2", "^", "13"}]}], ",", "2"}], "]"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ";;", "14"}], "]"}], "]"}], "&"}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"Map", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", "192"}], "+", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "&"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Map", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", "224"}], 
                    ",", 
                    RowBox[{"#", "-", 
                    RowBox[{"{", 
                    RowBox[{"129", ",", "64"}], "}"}]}], ",", 
                    RowBox[{"#", "-", 
                    RowBox[{"{", 
                    RowBox[{"193", ",", "64"}], "}"}]}]}], "]"}], "&"}], ",", 
                    
                    RowBox[{"Partition", "[", 
                    RowBox[{
                    RowBox[{"ToCharacterCode", "[", 
                    RowBox[{"input", ",", "\"\<ShiftJIS\>\""}], "]"}], ",", 
                    "2"}], "]"}]}], "]"}]}], "]"}]}], "]"}], ",", 
                "\[IndentingNewLine]", "\:7d42\:7aefPattern", ",", 
                RowBox[{"{", 
                 RowBox[{
                 "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
                  "0"}], "}"}]}], "]"}], "]"}], ",", "8"}], "]"}], ",", 
           "\[IndentingNewLine]", "dataSize", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", "1", ",", "0",
                ",", "0"}], " ", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
              "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0",
                ",", "1"}], "}"}]}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", "\:82f1\:6570\:5b57", ",", 
         "\[IndentingNewLine]", 
         RowBox[{"PadRight", "[", 
          RowBox[{
           RowBox[{"Partition", "[", 
            RowBox[{
             RowBox[{"Flatten", "[", "\[IndentingNewLine]", 
              RowBox[{"Join", "[", 
               RowBox[{
                RowBox[{
                "\:30e2\:30a6\:30c9", "[", "\:82f1\:6570\:5b57", "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"\:6587\:5b57\:6570", "[", 
                 RowBox[{"input", ",", "\"\<\:82f1\:6570\:5b57\>\""}], "]"}], 
                ",", "\[IndentingNewLine]", 
                RowBox[{"Map", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "#", "]"}], "\[Equal]", "2"}], ",",
                     "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"IntegerDigits", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#", ".", 
                    RowBox[{"{", 
                    RowBox[{"45", ",", "1"}], "}"}]}], "+", 
                    RowBox[{"2", "^", "11"}]}], ",", "2"}], "]"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ";;", "12"}], "]"}], "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"IntegerDigits", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"2", "^", "6"}]}], ",", "2"}], "]"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ";;", "7"}], "]"}], "]"}]}], "]"}], "&"}], 
                  ",", "\[IndentingNewLine]", 
                  RowBox[{"Partition", "[", 
                   RowBox[{
                    RowBox[{"Map", "[", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{"DigitQ", "[", "#", "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToCharacterCode", "[", "#", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", "48"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"LetterQ", "[", "#", "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToCharacterCode", "[", 
                    RowBox[{"ToUpperCase", "[", "#", "]"}], "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", "55"}], ",", 
                    "\[IndentingNewLine]", "True", ",", 
                    RowBox[{"Switch", "[", 
                    RowBox[{
                    "#", ",", "\"\< \>\"", ",", "36", ",", "\"\<$\>\"", ",", 
                    "37", ",", "\"\<%\>\"", ",", "38", ",", "\"\<*\>\"", ",", 
                    "39", ",", "\[IndentingNewLine]", "\"\<+\>\"", ",", "40", 
                    ",", "\"\<-\>\"", ",", "41", ",", "\"\<.\>\"", ",", "42", 
                    ",", "\"\</\>\"", ",", "43", ",", "\"\<:\>\"", ",", "44", 
                    ",", "_", ",", 
                    "\"\<\:30a8\:30e9\:30fc\:ff1a\:82f1\:6570\:5b57\:30e2\
\:30a6\:30c9\:3067\:306f\:6271\:3048\:307e\:305b\:3093\>\""}], "]"}]}], "]"}],
                     "&"}], ",", 
                    RowBox[{"Characters", "[", "input", "]"}]}], "]"}], ",", 
                    "2", ",", "2", ",", "1", ",", 
                    RowBox[{"{", "}"}]}], "]"}]}], "]"}], ",", 
                "\[IndentingNewLine]", "\:7d42\:7aefPattern", ",", 
                RowBox[{"{", 
                 RowBox[{
                 "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
                  "0"}], "}"}]}], "]"}], "]"}], ",", "8"}], "]"}], ",", 
           "\[IndentingNewLine]", "dataSize", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", "1", ",", "0",
                ",", "0"}], " ", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
              "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0",
                ",", "1"}], "}"}]}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"\:8aa4\:308a\:8a02\:6b63", "[", 
       RowBox[{"data", ",", "level"}], "]"}]}]}], " ", "\[IndentingNewLine]", 
    "]"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\:7b26\:53f7\:5316data", "[", 
   RowBox[{"input_", ",", "mode_", ",", "level_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"A", ",", "a", ",", "B", ",", "F"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"A", "=", 
      RowBox[{"Array", "[", 
       RowBox[{"a", ",", 
        RowBox[{"{", 
         RowBox[{"29", ",", "29"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"B", "=", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Reverse", "[", "#", "]"}], "&"}], ",", 
        RowBox[{"Reverse", "[", 
         RowBox[{"Drop", "[", 
          RowBox[{
           RowBox[{"Transpose", "[", 
            RowBox[{"A", "*", "dataArea"}], "]"}], ",", 
           RowBox[{"{", "7", "}"}]}], "]"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"i", "=", "1"}], ",", 
       RowBox[{"i", "<=", 
        RowBox[{"Length", "[", "B", "]"}]}], ",", 
       RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Mod", "[", 
             RowBox[{"i", ",", "4"}], "]"}], "\[Equal]", "3"}], "||", 
           RowBox[{
            RowBox[{"Mod", "[", 
             RowBox[{"i", ",", "4"}], "]"}], "\[Equal]", "0"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Part", "[", 
            RowBox[{"B", ",", "i"}], "]"}], "=", 
           RowBox[{"Reverse", "[", 
            RowBox[{"Part", "[", 
             RowBox[{"B", ",", "i"}], "]"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Part", "[", 
            RowBox[{"B", ",", "i"}], "]"}], "=", 
           RowBox[{"Part", "[", 
            RowBox[{"B", ",", "i"}], "]"}]}]}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"F", "=", 
      RowBox[{"{", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"Flatten", "[", 
          RowBox[{"Map", "[", 
           RowBox[{"Flatten", ",", 
            RowBox[{"Map", "[", 
             RowBox[{"Transpose", ",", 
              RowBox[{"Partition", "[", 
               RowBox[{"B", ",", "2"}], "]"}]}], "]"}]}], "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"Not", "[", 
           RowBox[{"SameQ", "[", 
            RowBox[{"#", ",", "0"}], "]"}], "]"}], "&"}]}], "]"}], "}"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Set", "[", 
         RowBox[{"#", ",", 
          RowBox[{"PadRight", "[", 
           RowBox[{
            RowBox[{"Flatten", "[", 
             RowBox[{"\:7b26\:53f7\:8a9e", "[", 
              RowBox[{"input", ",", "mode", ",", "level"}], "]"}], "]"}], ",",
             "567"}], "]"}]}], "]"}], "&"}], ",", "F"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"A", "*", "dataArea"}]}]}], "\[IndentingNewLine]", 
   "]"}]}], "\[IndentingNewLine]"}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.753844157063135*^9, 3.753844221426647*^9}, {
   3.753846061902164*^9, 3.75384615792702*^9}, {3.753846252379156*^9, 
   3.753846253703216*^9}, {3.754005395912489*^9, 3.754005549141684*^9}, {
   3.75400565776691*^9, 3.7540057112356977`*^9}, {3.754006224426466*^9, 
   3.754006225466381*^9}, {3.754006258704241*^9, 3.754006259262232*^9}, {
   3.754006294909699*^9, 3.754006363985238*^9}, {3.754006414637088*^9, 
   3.754006493075778*^9}, {3.754006588538731*^9, 3.754006667516821*^9}, {
   3.754006706008564*^9, 3.754006794832062*^9}, {3.754006827047593*^9, 
   3.75400683877669*^9}, {3.75401122106574*^9, 3.754011256082419*^9}, {
   3.754011404543692*^9, 3.754011407422944*^9}, 3.7540114564771423`*^9, {
   3.754012189427246*^9, 3.754012216093931*^9}, {3.7540122587832327`*^9, 
   3.754012263464745*^9}, {3.754012580485179*^9, 3.754012631724386*^9}, {
   3.7540126790674887`*^9, 3.754012691647731*^9}, {3.754012743525949*^9, 
   3.7540127465631533`*^9}, {3.754012801871385*^9, 3.754012816261992*^9}, {
   3.754012907833631*^9, 3.7540129499151163`*^9}, {3.754013006044443*^9, 
   3.75401304631144*^9}, {3.7540132201004868`*^9, 3.754013303033491*^9}, {
   3.7540134227277937`*^9, 3.754013464526102*^9}, {3.7540139026829653`*^9, 
   3.754014055791293*^9}, {3.7540141651529703`*^9, 3.754014279967812*^9}, {
   3.7540143639977713`*^9, 3.754014441920985*^9}, {3.754014513820088*^9, 
   3.754014575674655*^9}, {3.754014639149852*^9, 3.7540146498225937`*^9}, {
   3.7540146839518642`*^9, 3.7540147298880167`*^9}, {3.7540148199326687`*^9, 
   3.754014968896655*^9}, {3.754015088689582*^9, 3.754015117698333*^9}, {
   3.7540153674491653`*^9, 3.7540154537121077`*^9}, 3.754016408469212*^9, {
   3.754016463318858*^9, 3.754016501390788*^9}, 3.754016655012589*^9, 
   3.754017491162389*^9, {3.7540488705546*^9, 3.7540488823361607`*^9}, {
   3.7540489424094152`*^9, 3.754048965324389*^9}, {3.754049009751027*^9, 
   3.754049032240711*^9}, {3.754049074703047*^9, 3.7540491470888*^9}, {
   3.754049204061047*^9, 3.7540494543046417`*^9}, {3.7540495235466557`*^9, 
   3.754049571756494*^9}, {3.75404960777663*^9, 3.75404962268948*^9}, {
   3.754049666649643*^9, 3.7540496679944353`*^9}, {3.754051114103813*^9, 
   3.754051150611823*^9}, {3.754051282087576*^9, 3.754051315720265*^9}, {
   3.7540513851845818`*^9, 3.754051385749819*^9}, {3.754051417795587*^9, 
   3.754051532769575*^9}, 3.7540516623662043`*^9, {3.754052039019067*^9, 
   3.754052061629983*^9}, {3.7839916939445667`*^9, 3.783991693991261*^9}, 
   3.783991957489867*^9},
 CellLabel->"In[33]:=",ExpressionUUID->"126e0b33-168a-4315-82e0-231467dbfc1a"]
}, Closed]],

Cell[CellGroupData[{

Cell["\:8868\:793a", "Subsection",
 InitializationCell->True,
 CellChangeTimes->{{3.753829384713773*^9, 3.753829396283124*^9}, 
   3.753829459429019*^9, {3.753831714001927*^9, 3.7538317155679007`*^9}, 
   3.754003232205502*^9, {3.754003379006363*^9, 
   3.7540033842421513`*^9}},ExpressionUUID->"6109b62a-a314-4b3d-9390-\
e0612233a06c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"black", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Rectangle", "[", "]"}], ",", 
     RowBox[{"Background", "\[Rule]", "Black"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"white", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"White", ",", 
       RowBox[{"Rectangle", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"bit", "[", "1", "]"}], "=", "black"}], ";", 
  RowBox[{
   RowBox[{"bit", "[", "0", "]"}], "=", "white"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\:8868\:793a", "[", "matrix_", "]"}], ":=", 
  RowBox[{"GraphicsGrid", "[", 
   RowBox[{
    RowBox[{"Map", "[", 
     RowBox[{"bit", ",", 
      RowBox[{"Mod", "[", 
       RowBox[{"matrix", ",", "2"}], "]"}], ",", 
      RowBox[{"{", "2", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Spacings", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "Medium"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QRcode", "[", 
   RowBox[{
   "string_", ",", "version_", ",", "mode_", ",", "level_", ",", "mask_"}], 
   "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"\:8868\:793a", "[", 
   RowBox[{
    RowBox[{"frame", "[", "version", "]"}], "+", 
    RowBox[{"\:5f62\:5f0f\:60c5\:5831", "[", 
     RowBox[{"level", ",", "mask"}], "]"}], "+", 
    RowBox[{"\:7b26\:53f7\:5316data", "[", 
     RowBox[{"string", ",", "mode", ",", "level"}], "]"}], "+", 
    RowBox[{"\:30de\:30b9\:30af", "[", "mask", "]"}]}], "]"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.753997186039198*^9, 3.753997195693548*^9}, {
   3.753997225743617*^9, 3.753997226278575*^9}, {3.753997939975513*^9, 
   3.753997943865354*^9}, {3.754003020244802*^9, 3.754003024470667*^9}, 
   3.7540035557172813`*^9, 3.754018210532013*^9, {3.7839896243606167`*^9, 
   3.783989625479373*^9}, 3.783991719155593*^9, 3.783991952471904*^9},
 CellLabel->"In[36]:=",ExpressionUUID->"112c70ed-5a36-48e3-aa6d-02c9df5b20a9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"frame", "[", "3", "]"}], "=", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", 
       "1", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "1", ",", 
       "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}]}], "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.7540034775982037`*^9, {3.7540035342218733`*^9, 3.75400355571778*^9}, {
   3.7540088769666157`*^9, 3.754008880392578*^9}, 3.75401821053263*^9, {
   3.754048672297503*^9, 3.75404867840994*^9}, 3.754048784195402*^9, {
   3.754050977065775*^9, 3.754050995942068*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"00f23a28-3eaf-45cc-820e-cadb5b5f25b9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dataArea", "=", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1"}], "}"}]}], "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.7536435616478653`*^9, 3.7536435812011147`*^9}, {
   3.753729555997998*^9, 3.753729556564805*^9}, 3.753997283153035*^9, {
   3.7540034577897177`*^9, 3.754003477599019*^9}, {3.7540035342225924`*^9, 
   3.754003555718155*^9}, 3.754018210533023*^9},
 CellLabel->"In[42]:=",ExpressionUUID->"d780ff9a-89cc-4d50-a486-9d8046f53bd7"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QRcode", "[", 
  RowBox[{
  "\"\<\:7dcf\:5408\:6559\:80b2\:79d1\:76ee\:6f14\:7fd2\:3000\:62c5\:5f53\
\:3000\:936c\:7530\>\"", ",", "3", ",", "\:6f22\:5b57", ",", "H", ",", 
   "001"}], "]"}]], "Input",
 CellChangeTimes->{{3.754050690661006*^9, 3.754050725677717*^9}, {
   3.754051080609014*^9, 3.754051088232168*^9}, {3.783989709537444*^9, 
   3.783989711684754*^9}, 3.783991720547543*^9},
 CellLabel->"In[43]:=",ExpressionUUID->"556f038e-a497-48d4-97f2-f44732b676e7"],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -540.}, ImageScaled[{0.5, 0.5}], {360, 360.}],\
 InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -1260.}, ImageScaled[{0.5, 0.5}], 
      {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {180, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2340, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {180, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2700, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2340, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2700, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2340, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -4140.}, ImageScaled[{0.5, 0.5}], 
      {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2700, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2340, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {180, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2700, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {180, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2340, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -5940.}, ImageScaled[{0.5, 0.5}], 
      {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {180, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2340, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2700, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {180, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2340, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {180, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2340, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}}, {}},
  ContentSelectable->True,
  ImageSize->Medium,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.783989701412983*^9, 3.7839897149166*^9}, 
   3.783991740170545*^9, 3.7839919786164103`*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"a1cee838-36b3-410a-8566-c7a40dd576ae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QRcode", "[", 
  RowBox[{"\"\<http://c-faculty.chuo-u.ac.jp/~kuwata/\>\"", ",", "3", ",", 
   RowBox[{"8", "bit"}], ",", "M", ",", "110"}], "]"}]], "Input",
 CellChangeTimes->{{3.7540184127691298`*^9, 3.754018422543315*^9}, {
   3.7540191928582907`*^9, 3.754019286963426*^9}, {3.7540193291406527`*^9, 
   3.754019372480052*^9}, {3.754019448652618*^9, 3.754019497919269*^9}, {
   3.754050768050968*^9, 3.754050778558505*^9}, 
   3.7839917217613153`*^9},ExpressionUUID->"7bd7a0e7-cb3a-44ab-93e5-\
242414fb0feb"],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -540.}, ImageScaled[{0.5, 0.5}], {360, 360.}],\
 InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {180, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2340, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2700, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2340, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2340, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2700, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {180, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2700, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2340, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2700, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2340, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2700, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2700, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -6300.}, ImageScaled[{0.5, 0.5}], 
      {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2340, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2700, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2340, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2700, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {180, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2340, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}}, {}},
  ContentSelectable->True,
  ImageSize->Medium,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.754018402522057*^9, 3.7540184262070923`*^9}, {
   3.75401921402162*^9, 3.754019260776856*^9}, 3.754019299087229*^9, {
   3.7540193327358427`*^9, 3.754019375214142*^9}, {3.754019451374638*^9, 
   3.754019500601267*^9}, 3.754050781174404*^9, 3.754050929247158*^9, 
   3.7540510170694*^9, 3.7839792617746468`*^9, 3.783989724152082*^9},
 CellLabel->"Out[45]=",ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztnMGO2kAMhhP1CpwznLjAPXmA9LYrIfVazohdCQ4VFeW6D7NPSjtWa++Y
CYuqFtLmQwJZdv7PSGQ8Mx7g0/q4ff6yPu4269njYf11u9t8mz3sDz9cH8qi
KLfxOSuifSqKXy/y2MWXovgcXeNoj6LVRKuK1kJ9o2iNo/WEBs3tNeJtNR7U
Ek5QTUijtfrGGXYJGzbswbLFu1BLfHNVz1UTMpwqzTKHDRs2bM+2K61W5arW
OPNurq9aZCELWcjyX2RxVVfYsj+UneIqWhVEiBB7SWxTTpupGU1aHxaoUQ9H
7fqfNsbsShltNttaFjhw4Fzm7PWioCE3MB0WIcL7CCvV2FxRp3e1qPfRmqBB
c3uN1Vu5h5fRGqX3eme3VLJM4cCBc5HjVjYho7EZxGWpNVpChAixH0TXBXea
Rq06tSaoUQ9MbWPMWTmijE87j7JR+REiRIh9Iy7SuH2LZpNmsW6es+zd5E+u
YMOGDfu32W2XpsloxJKaJxWxgQgRYi+JtloJWilEI6cvdZrFcQIcOHDe4Zx+
fhXs2gn3ysYZWLBgwbqStdS4WwjkfLY5aDULRIgQ+0Ss0qpgB+ZtSpQFyEqj
U9Soh6O2GTOkHJsnrSkvlsvntBI9O4CDDRv2YNiiWabVyKml1e7W53adZD5r
KUCECPE+xFcNWc/8hdCfCnX+QslZ7kPsVKzefHSwYcMeFlvi7h/OglqVRl0W
88GBA+cyx5ZQuXFqozO3hbIF1qjLRz7ykY985PuL+WQnZr8faSBChPjvE60x
LZYdEQfYsGHDvg/b/bdb50rHOsTuQB8iRIh9Inb2cY0T1CdH7Fd1gVGj7pW6
KL8Dc/uX2g==\
\>"],ExpressionUUID->"34c12ee0-1ed8-4684-8364-8263aec4470e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QRcode", "[", 
  RowBox[{
  "\"\<1B00010030:19B4143011L\>\"", ",", "3", ",", "\:82f1\:6570\:5b57", ",", 
   "H", ",", "000"}], "]"}]], "Input",
 CellChangeTimes->{{3.754051555356522*^9, 3.754051577017809*^9}, 
   3.754051617214635*^9, {3.7540519200013638`*^9, 3.754051965522625*^9}, 
   3.754052070608344*^9, {3.754077486116721*^9, 3.7540775530794983`*^9}, 
   3.754078034971299*^9, {3.7839898030607023`*^9, 3.783989829479505*^9}, 
   3.783991722898026*^9},ExpressionUUID->"c3dab018-e850-409e-bacc-\
a47993b35e05"],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -1260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -1620.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -1980.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -2340.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {180, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2340, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -2700.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {180, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -3060.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {180, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2340, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2700, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -3420.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {180, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -3780.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {180, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2340, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -4140.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {180, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2700, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -4500.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {180, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2340, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2700, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -4860.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -5220.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2340, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -5580.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -5940.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {180, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2340, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -6300.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2700, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -6660.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {180, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2340, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2700, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -7020.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2700, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -7380.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {180, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2340, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -7740.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -8100.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -8460.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5940, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -8820.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4860, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6300, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7740, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {10260, -9180.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3060, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3780, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4140, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7020, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -9540.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {540, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {900, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1260, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1620, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {1980, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3420, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {4500, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5220, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5580, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6660, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7380, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8100, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8460, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8820, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9180, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9540, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9900, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -9900.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}, {InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {180, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {540, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {900, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1260, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1620, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {1980, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {2340, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {2700, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3060, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {3420, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {3780, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4140, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4500, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {4860, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {5220, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5580, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {5940, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {6300, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {6660, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {7020, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7380, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {7740, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8100, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {8460, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {8820, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9180, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {9540, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[
       {GrayLevel[1], RectangleBox[{0, 0}]},
       Background->GrayLevel[1]], {9900, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}],
       Background->GrayLevel[0]], {10260, -10260.}, 
      ImageScaled[{0.5, 0.5}], {360, 360.}]}}, {}},
  ContentSelectable->True,
  ImageSize->Medium,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.754051581961447*^9, 3.754051619987866*^9, {3.754051673683123*^9, 
   3.754051679531945*^9}, {3.754051900780683*^9, 3.754051967981276*^9}, 
   3.754052072913947*^9, {3.7540774969438667`*^9, 3.754077555244101*^9}, 
   3.754078040309318*^9, 3.7839792716290083`*^9, {3.783989816668625*^9, 
   3.783989832873788*^9}},
 CellLabel->"Out[47]=",ExpressionUUID->"883f03c6-ebcf-4917-9463-6f097ff59610"]
}, Open  ]]
},
CellGrouping->Manual,
WindowSize->{808, 755},
WindowMargins->{{Automatic, 119}, {Automatic, 0}},
FrontEndVersion->"11.3 for Mac OS X x86 (32-bit, 64-bit Kernel) (2018\:5e743\
\:670812\:65e5)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 189, 3, 67, "Section",ExpressionUUID->"e07f9a12-48e4-42b5-b009-1b0d75e66552"],
Cell[CellGroupData[{
Cell[794, 29, 184, 4, 54, "Subsection",ExpressionUUID->"b7d2c6a5-280d-436e-b356-17169095a4e9",
 InitializationCell->True],
Cell[981, 35, 2005, 56, 191, "Input",ExpressionUUID->"90b69506-5311-4d64-8c37-22f9f4afe4a7",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[3023, 96, 190, 4, 38, "Subsection",ExpressionUUID->"d4376af0-c42c-4048-8dd5-645d6268b3c6",
 InitializationCell->True],
Cell[3216, 102, 3206, 79, 391, "Input",ExpressionUUID->"91114228-e766-405b-bc56-3bf22474f0ff",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[6459, 186, 255, 5, 38, "Subsection",ExpressionUUID->"f3cae15e-5244-4ac7-8440-06abe5daf437",
 InitializationCell->True],
Cell[6717, 193, 1005, 26, 131, "Input",ExpressionUUID->"0302a324-1e0f-4511-940b-1cfd96afebe8",
 InitializationCell->True],
Cell[7725, 221, 1456, 38, 72, "Input",ExpressionUUID->"6914f19c-1fae-4fac-adfa-8f5657336b0c",
 InitializationCell->True],
Cell[9184, 261, 1002, 27, 68, "Input",ExpressionUUID->"8af800ad-e210-4a76-93e9-fc097df2c871",
 InitializationCell->True],
Cell[10189, 290, 1827, 51, 89, "Input",ExpressionUUID->"ff6bb003-f28d-48f1-861c-0567caed9f01",
 InitializationCell->True],
Cell[12019, 343, 2358, 64, 318, "Input",ExpressionUUID->"8bcea365-3d44-4deb-b76b-3bab200fd319",
 InitializationCell->True],
Cell[14380, 409, 939, 26, 89, "Input",ExpressionUUID->"2f796dc2-6250-42bd-b017-2455df9704bf",
 InitializationCell->True],
Cell[15322, 437, 715, 18, 60, "Input",ExpressionUUID->"d8dfb0e1-8e72-4cc4-90ef-49842a5cb832",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[16074, 460, 324, 6, 38, "Subsection",ExpressionUUID->"d9fb9af3-4880-4d19-b515-e7c1dc524331",
 InitializationCell->True],
Cell[16401, 468, 8898, 227, 558, "Input",ExpressionUUID->"1c8ae614-29bb-427a-bbbc-b24b8dc16161",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[25336, 700, 291, 5, 38, "Subsection",ExpressionUUID->"0ffcaa2a-8f7b-4b4b-a5af-5998bd8d9dca",
 InitializationCell->True],
Cell[25630, 707, 5551, 170, 348, "Input",ExpressionUUID->"94625f43-5b98-4da4-94c9-a84cfe6d08e4",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[31218, 882, 394, 7, 38, "Subsection",ExpressionUUID->"5483aa85-60b6-4eb8-9694-36c76aed6b17",
 InitializationCell->True],
Cell[31615, 891, 24198, 543, 2661, "Input",ExpressionUUID->"126e0b33-168a-4315-82e0-231467dbfc1a",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[55850, 1439, 336, 6, 38, "Subsection",ExpressionUUID->"6109b62a-a314-4b3d-9390-e0612233a06c",
 InitializationCell->True],
Cell[56189, 1447, 2176, 56, 258, "Input",ExpressionUUID->"112c70ed-5a36-48e3-aa6d-02c9df5b20a9",
 InitializationCell->True],
Cell[58368, 1505, 11334, 215, 656, "Input",ExpressionUUID->"00f23a28-3eaf-45cc-820e-cadb5b5f25b9",
 InitializationCell->True],
Cell[69705, 1722, 11288, 213, 656, "Input",ExpressionUUID->"d780ff9a-89cc-4d50-a486-9d8046f53bd7",
 InitializationCell->True]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[81042, 1941, 492, 9, 33, "Input",ExpressionUUID->"556f038e-a497-48d4-97f2-f44732b676e7"],
Cell[81537, 1952, 132834, 2938, 411, "Output",ExpressionUUID->"a1cee838-36b3-410a-8566-c7a40dd576ae"]
}, Open  ]],
Cell[CellGroupData[{
Cell[214408, 4895, 533, 9, 30, "Input",ExpressionUUID->"7bd7a0e7-cb3a-44ab-93e5-242414fb0feb"],
Cell[214944, 4906, 134190, 2965, 377, 132833, 2943, "CachedBoxData", "BoxData", "Output",ExpressionUUID->"34c12ee0-1ed8-4684-8364-8263aec4470e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[349171, 7876, 538, 10, 33, "Input",ExpressionUUID->"c3dab018-e850-409e-bacc-a47993b35e05"],
Cell[349712, 7888, 133206, 2948, 377, "Output",ExpressionUUID->"883f03c6-ebcf-4917-9463-6f097ff59610"]
}, Open  ]]
}
]
*)

