(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3 *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     16168,        429]
NotebookOptionsPosition[     15142,        402]
NotebookOutlinePosition[     15508,        418]
CellTagsIndexPosition[     15465,        415]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"\:751f\:6210\:5143", "=", 
   RowBox[{
    SuperscriptBox["\[Gamma]", "8"], "+", 
    SuperscriptBox["\[Gamma]", "4"], "+", 
    SuperscriptBox["\[Gamma]", "3"], "+", 
    SuperscriptBox["\[Gamma]", "2"], "+", "1"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\:52a0\:6cd5\:8868\:793a", "[", "x_", "]"}], ":=", 
  RowBox[{"PolynomialMod", "[", 
   RowBox[{"x", ",", 
    RowBox[{"{", 
     RowBox[{"\:751f\:6210\:5143", ",", "2"}], "}"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"F256", "=", 
   RowBox[{"Prepend", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"\:52a0\:6cd5\:8868\:793a", "[", 
        SuperscriptBox["\[Gamma]", "k"], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "254"}], "}"}]}], "]"}], ",", "0"}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"\:4f4d\:7f6e", "[", 
    RowBox[{"L_", ",", "e_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"Position", "[", 
      RowBox[{"L", ",", "e"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"\:4e57\:6cd5\:8868\:793a", "[", "x_", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"x", "===", "0"}], ",", "0", ",", 
     RowBox[{"\[Gamma]", "^", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\:4f4d\:7f6e", "[", 
         RowBox[{"F256", ",", 
          RowBox[{"\:52a0\:6cd5\:8868\:793a", "[", "x", "]"}]}], "]"}], "-", 
        "2"}], ")"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:751f\:6210\:591a\:9805\:5f0f", " ", "=", 
    RowBox[{"PolynomialMod", "[", 
     RowBox[{
      RowBox[{"Product", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "+", 
          SuperscriptBox["\[Gamma]", "k"]}], ")"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "0", ",", "12"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"\:751f\:6210\:5143", ",", "2"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\:6f22\:5b57Mode", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:6587\:5b57\:6570", "[", 
    RowBox[{"data_", ",", "\"\<\:6f22\:5b57\>\""}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"IntegerDigits", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"StringLength", "[", "data", "]"}], ",", "2", ",", "8"}], "]"}],
     "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:305a\:3089\:3057", "[", "code_", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"code", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", "224"}], ",", 
     RowBox[{"code", "-", 
      RowBox[{"{", 
       RowBox[{"129", ",", "64"}], "}"}]}], ",", 
     RowBox[{"code", "-", 
      RowBox[{"{", 
       RowBox[{"193", ",", "64"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:6f22\:5b57Data", "[", "data_", "]"}], ":=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"IntegerDigits", "[", 
       RowBox[{"#", ",", "2", ",", "13"}], "]"}], "&"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "*", "192"}], "+", 
         RowBox[{"#", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "&"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Map", "[", 
        RowBox[{"\:305a\:3089\:3057", ",", 
         RowBox[{"Partition", "[", 
          RowBox[{
           RowBox[{"ToCharacterCode", "[", 
            RowBox[{"data", ",", "\"\<ShiftJIS\>\""}], "]"}], ",", "2"}], 
          "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\:7d42\:7aefPattern", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:6f22\:5b57\:60c5\:5831\:8a9e", "[", "data_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Partition", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Partition", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", "\[IndentingNewLine]", 
         RowBox[{"Join", "[", 
          RowBox[{"\:6f22\:5b57Mode", ",", 
           RowBox[{"\:6587\:5b57\:6570", "[", 
            RowBox[{"data", ",", "\"\<\:6f22\:5b57\>\""}], "]"}], ",", 
           RowBox[{"\:6f22\:5b57Data", "[", "data", "]"}], ",", 
           "\:7d42\:7aefPattern"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
        "8", ",", "8", ",", "1", ",", "0"}], "]"}], ",", 
      "\[IndentingNewLine]", "13", ",", "13", ",", "1", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", "1", ",", "0", ",",
           "0"}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
         "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",",
           "1"}], "}"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:60c5\:5831\:591a\:9805\:5f0f", "[", "word_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"\:52a0\:6cd5\:8868\:793a", "[", 
        RowBox[{"#", ".", 
         RowBox[{"Table", "[", 
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            RowBox[{"(", 
             RowBox[{"7", "-", "i"}], ")"}]], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "0", ",", "7"}], "}"}]}], "]"}]}], "]"}], "&"}],
       ",", "word"}], "\[IndentingNewLine]", "]"}], ".", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"13", "-", "i"}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "13"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:7b26\:53f7\:591a\:9805\:5f0f", "[", "poly_", "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Collect", "[", 
    RowBox[{
     RowBox[{"PolynomialMod", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"poly", "*", 
         RowBox[{"x", "^", "13"}]}], "+", 
        RowBox[{"PolynomialRemainder", "[", 
         RowBox[{
          RowBox[{"poly", "*", 
           RowBox[{"x", "^", "13"}]}], ",", "\:751f\:6210\:591a\:9805\:5f0f", 
          ",", "x"}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"\:751f\:6210\:5143", ",", "2"}], "}"}]}], "]"}], ",", "x"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:9001\:4fe1\:8a9e", "[", "poly_", "]"}], ":=", 
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Coefficient", "[", 
           RowBox[{
            RowBox[{"\:52a0\:6cd5\:8868\:793a", "[", "#", "]"}], ",", 
            "\[Gamma]", ",", 
            RowBox[{"7", "-", "i"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "0", ",", "7"}], "}"}]}], "]"}], " ", "&"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"poly", ",", "x", ",", 
           RowBox[{"25", "-", "i"}]}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"i", ",", "0", ",", "25"}], "}"}]}], "]"}]}], "]"}], ",", 
     "2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:6f22\:5b57QRcode", "[", "moji_", "]"}], ":=", 
   RowBox[{"\:9001\:4fe1\:8a9e", "[", 
    RowBox[{"\:7b26\:53f7\:591a\:9805\:5f0f", "[", 
     RowBox[{"\:60c5\:5831\:591a\:9805\:5f0f", "[", 
      RowBox[{"\:6f22\:5b57\:60c5\:5831\:8a9e", "[", "moji", "]"}], "]"}], 
     "]"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.722077546995715*^9, {3.748234644023302*^9, 3.748234649100937*^9}, {
   3.748236181555641*^9, 3.748236183031871*^9}, {3.748236542474773*^9, 
   3.748236567321085*^9}, {3.748252275244068*^9, 3.748252376891498*^9}, {
   3.748307556542931*^9, 3.748307556870329*^9}, {3.748650154387142*^9, 
   3.7486501552269173`*^9}, {3.783298434904001*^9, 3.7832984435825777`*^9}, {
   3.783298475422412*^9, 3.783298483868539*^9}, {3.783298521830813*^9, 
   3.78329853402421*^9}, {3.7833008707280903`*^9, 3.78330092521212*^9}, {
   3.783301484621827*^9, 3.783301501308826*^9}, {3.783374228400305*^9, 
   3.7833742290497923`*^9}, 3.783374331650654*^9, {3.783374379178931*^9, 
   3.783374395755802*^9}},
 Background->GrayLevel[0.85],
 CellLabel->"In[88]:=",ExpressionUUID->"b76be31e-e640-47cd-b798-7b82d1eaf111"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
  "\:6f22\:5b57\:60c5\:5831\:8a9e", "[", 
   "\"\<\:8349\:91ce\:307f\:3069\:308a\>\"", "]"}], "//", 
  "TableForm"}]], "Input",
 CellChangeTimes->{{3.748236442707165*^9, 3.748236472531723*^9}, {
  3.748236766259313*^9, 3.74823676837519*^9}, {3.748252445444997*^9, 
  3.748252466348406*^9}, {3.7483075595974894`*^9, 3.7483075599407597`*^9}, {
  3.7486501612660923`*^9, 3.748650161895681*^9}, {3.78330092824597*^9, 
  3.7833009671832314`*^9}, {3.7833742669483137`*^9, 3.783374270218218*^9}},
 CellLabel->
  "In[104]:=",ExpressionUUID->"681dc0a1-4d90-4654-ba5d-6955be81516d"],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "0", "0", "0", "0", "0", "0", "0"},
    {"0", "1", "0", "1", "0", "1", "1", "0"},
    {"0", "0", "1", "0", "1", "0", "0", "0"},
    {"0", "1", "0", "0", "0", "0", "0", "1"},
    {"1", "0", "1", "1", "0", "0", "0", "0"},
    {"0", "0", "1", "0", "1", "0", "1", "1"},
    {"1", "0", "1", "0", "0", "0", "0", "1"},
    {"0", "1", "0", "0", "0", "1", "1", "1"},
    {"0", "0", "0", "0", "1", "0", "1", "1"},
    {"0", "1", "0", "0", "0", "0", "0", "0"},
    {"0", "0", "0", "0", "0", "0", "0", "0"},
    {"0", "0", "0", "1", "0", "0", "0", "1"},
    {"1", "1", "1", "0", "1", "1", "0", "0"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.783301024873308*^9, 3.78330152119235*^9, {3.783374272586145*^9, 
   3.783374309839098*^9}, 3.783374403571286*^9},
 CellLabel->
  "Out[104]//TableForm=",ExpressionUUID->"a064d041-c02d-457b-b7c3-\
10f50aca5f2e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ExportString", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{
         RowBox[{
         "\:6f22\:5b57QRcode", "[", "\"\<\:8349\:91ce\:307f\:3069\:308a\>\"", 
          "]"}], "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "26"}], "}"}]}], "]"}], ",", 
    "\"\<Table\>\""}], "]"}], "//", "TableForm"}]], "Input",
 CellChangeTimes->{{3.783301003086499*^9, 3.78330101453189*^9}, {
  3.783374408894021*^9, 3.7833744126557007`*^9}},
 CellLabel->
  "In[105]:=",ExpressionUUID->"7c537ec8-9fb8-4e4a-a4d8-ac971fd8732c"],

Cell[BoxData[
 TagBox["\<\"1\\t{1, 0, 0, 0, 0, 0, 0, 0}\\n2\\t{0, 1, 0, 1, 0, 1, 1, \
0}\\n3\\t{0, 0, 1, 0, 1, 0, 0, 0}\\n4\\t{0, 1, 0, 0, 0, 0, 0, 1}\\n5\\t{1, 0, \
1, 1, 0, 0, 0, 0}\\n6\\t{0, 0, 1, 0, 1, 0, 1, 1}\\n7\\t{1, 0, 1, 0, 0, 0, 0, \
1}\\n8\\t{0, 1, 0, 0, 0, 1, 1, 1}\\n9\\t{0, 0, 0, 0, 1, 0, 1, 1}\\n10\\t{0, \
1, 0, 0, 0, 0, 0, 0}\\n11\\t{0, 0, 0, 0, 0, 0, 0, 0}\\n12\\t{0, 0, 0, 1, 0, \
0, 0, 1}\\n13\\t{1, 1, 1, 0, 1, 1, 0, 0}\\n14\\t{0, 0, 1, 0, 0, 0, 1, 0}\\n15\
\\t{1, 0, 0, 0, 1, 1, 1, 0}\\n16\\t{1, 0, 1, 1, 0, 0, 1, 1}\\n17\\t{0, 1, 0, \
1, 0, 0, 1, 1}\\n18\\t{1, 0, 1, 1, 0, 1, 1, 0}\\n19\\t{1, 0, 1, 1, 1, 0, 0, \
1}\\n20\\t{1, 1, 1, 0, 1, 1, 0, 0}\\n21\\t{0, 0, 1, 0, 0, 0, 1, 1}\\n22\\t{1, \
1, 1, 1, 0, 0, 1, 0}\\n23\\t{0, 1, 0, 1, 0, 0, 0, 1}\\n24\\t{0, 1, 0, 1, 1, \
0, 1, 0}\\n25\\t{0, 0, 1, 0, 0, 0, 0, 0}\\n26\\t{0, 0, 1, 0, 0, 0, 0, 1}\"\>",
  
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.783301021073656*^9, 3.78330152684282*^9, 
  3.783374415819481*^9},
 CellLabel->
  "Out[105]//TableForm=",ExpressionUUID->"7567c38a-0262-4cd5-89c8-\
45b901b39e76"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
      "\:6f22\:5b57QRcode", "[", "\"\<\:8349\:91ce\:307f\:3069\:308a\>\"", 
       "]"}], "[", 
      RowBox[{"[", "i", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "26"}], "}"}]}], "]"}], ",", 
   "\"\<TSV\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.7833010741426888`*^9, 3.7833010996135*^9}, {
  3.783301548036241*^9, 3.7833015525145082`*^9}, {3.7833744748183126`*^9, 
  3.783374476501292*^9}},
 CellLabel->
  "In[107]:=",ExpressionUUID->"8add2121-d9b3-4184-aa33-f7d838e04530"],

Cell[BoxData["\<\"1\\t0\\t0\\t0\\t0\\t0\\t0\\t0\\n0\\t1\\t0\\t1\\t0\\t1\\t1\\\
t0\\n0\\t0\\t1\\t0\\t1\\t0\\t0\\t0\\n0\\t1\\t0\\t0\\t0\\t0\\t0\\t1\\n1\\t0\\\
t1\\t1\\t0\\t0\\t0\\t0\\n0\\t0\\t1\\t0\\t1\\t0\\t1\\t1\\n1\\t0\\t1\\t0\\t0\\\
t0\\t0\\t1\\n0\\t1\\t0\\t0\\t0\\t1\\t1\\t1\\n0\\t0\\t0\\t0\\t1\\t0\\t1\\t1\\\
n0\\t1\\t0\\t0\\t0\\t0\\t0\\t0\\n0\\t0\\t0\\t0\\t0\\t0\\t0\\t0\\n0\\t0\\t0\\\
t1\\t0\\t0\\t0\\t1\\n1\\t1\\t1\\t0\\t1\\t1\\t0\\t0\\n0\\t0\\t1\\t0\\t0\\t0\\\
t1\\t0\\n1\\t0\\t0\\t0\\t1\\t1\\t1\\t0\\n1\\t0\\t1\\t1\\t0\\t0\\t1\\t1\\n0\\\
t1\\t0\\t1\\t0\\t0\\t1\\t1\\n1\\t0\\t1\\t1\\t0\\t1\\t1\\t0\\n1\\t0\\t1\\t1\\\
t1\\t0\\t0\\t1\\n1\\t1\\t1\\t0\\t1\\t1\\t0\\t0\\n0\\t0\\t1\\t0\\t0\\t0\\t1\\\
t1\\n1\\t1\\t1\\t1\\t0\\t0\\t1\\t0\\n0\\t1\\t0\\t1\\t0\\t0\\t0\\t1\\n0\\t1\\\
t0\\t1\\t1\\t0\\t1\\t0\\n0\\t0\\t1\\t0\\t0\\t0\\t0\\t0\\n0\\t0\\t1\\t0\\t0\\\
t0\\t0\\t1\\n\"\>"], "Output",
 CellChangeTimes->{{3.783301086856724*^9, 3.78330110190252*^9}, {
   3.783301531825615*^9, 3.783301554928131*^9}, 3.7833744223238983`*^9, 
   3.783374479482862*^9},
 CellLabel->
  "Out[107]=",ExpressionUUID->"03f2ae1f-d4c7-4ba4-aeed-81a255d20c32"]
}, Open  ]]
},
WindowSize->{808, 755},
WindowMargins->{{Automatic, 102}, {Automatic, 0}},
FrontEndVersion->"11.3 for Mac OS X x86 (32-bit, 64-bit Kernel) (2018\:5e743\
\:670812\:65e5)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 8934, 243, 1040, "Input",ExpressionUUID->"b76be31e-e640-47cd-b798-7b82d1eaf111",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[9516, 267, 607, 12, 46, "Input",ExpressionUUID->"681dc0a1-4d90-4654-ba5d-6955be81516d"],
Cell[10126, 281, 1334, 33, 246, "Output",ExpressionUUID->"a064d041-c02d-457b-b7c3-10f50aca5f2e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11497, 319, 692, 19, 82, "Input",ExpressionUUID->"7c537ec8-9fb8-4e4a-a4d8-ac971fd8732c"],
Cell[12192, 340, 1123, 19, 571, "Output",ExpressionUUID->"7567c38a-0262-4cd5-89c8-45b901b39e76"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13352, 364, 634, 17, 46, "Input",ExpressionUUID->"8add2121-d9b3-4184-aa33-f7d838e04530"],
Cell[13989, 383, 1137, 16, 581, "Output",ExpressionUUID->"03f2ae1f-d4c7-4ba4-aeed-81a255d20c32"]
}, Open  ]]
}
]
*)

