(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     16931,        444]
NotebookOptionsPosition[     15849,        418]
NotebookOutlinePosition[     16196,        433]
CellTagsIndexPosition[     16153,        430]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"\:751f\:6210\:5143", "=", 
   RowBox[{
    SuperscriptBox["\[Gamma]", "8"], "+", 
    SuperscriptBox["\[Gamma]", "4"], "+", 
    SuperscriptBox["\[Gamma]", "3"], "+", 
    SuperscriptBox["\[Gamma]", "2"], "+", "1"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\:52a0\:6cd5\:8868\:793a", "[", "x_", "]"}], ":=", 
  RowBox[{"PolynomialMod", "[", 
   RowBox[{"x", ",", 
    RowBox[{"{", 
     RowBox[{"\:751f\:6210\:5143", ",", "2"}], "}"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"F256", "=", 
   RowBox[{"Prepend", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"\:52a0\:6cd5\:8868\:793a", "[", 
        SuperscriptBox["\[Gamma]", "k"], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "254"}], "}"}]}], "]"}], ",", "0"}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"\:4f4d\:7f6e", "[", 
    RowBox[{"L_", ",", "e_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"Position", "[", 
      RowBox[{"L", ",", "e"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"\:4e57\:6cd5\:8868\:793a", "[", "x_", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"x", "===", "0"}], ",", "0", ",", 
     RowBox[{"\[Gamma]", "^", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\:4f4d\:7f6e", "[", 
         RowBox[{"F256", ",", 
          RowBox[{"\:52a0\:6cd5\:8868\:793a", "[", "x", "]"}]}], "]"}], "-", 
        "2"}], ")"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:751f\:6210\:591a\:9805\:5f0f", "[", 
    RowBox[{"n_", ",", "k_"}], "]"}], " ", ":=", 
   RowBox[{"Collect", "[", 
    RowBox[{
     RowBox[{"Product", "[", 
      RowBox[{
       RowBox[{"x", "+", 
        RowBox[{"\[Gamma]", "^", "i"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", 
         RowBox[{"n", "-", "k", "-", "1"}]}], "}"}]}], "]"}], ",", "x", ",", 
     "\:4e57\:6cd5\:8868\:793a"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\:6f22\:5b57Mode", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:6587\:5b57\:6570", "[", 
    RowBox[{"data_", ",", "\"\<\:6f22\:5b57\>\""}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"IntegerDigits", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"StringLength", "[", "data", "]"}], ",", "2", ",", "8"}], "]"}],
     "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:305a\:3089\:3057", "[", "code_", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"code", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", "224"}], ",", 
     RowBox[{"code", "-", 
      RowBox[{"{", 
       RowBox[{"129", ",", "64"}], "}"}]}], ",", 
     RowBox[{"code", "-", 
      RowBox[{"{", 
       RowBox[{"193", ",", "64"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:6f22\:5b57Data", "[", "data_", "]"}], ":=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"IntegerDigits", "[", 
       RowBox[{"#", ",", "2", ",", "13"}], "]"}], "&"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "*", "192"}], "+", 
         RowBox[{"#", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "&"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Map", "[", 
        RowBox[{"\:305a\:3089\:3057", ",", 
         RowBox[{"Partition", "[", 
          RowBox[{
           RowBox[{"ToCharacterCode", "[", 
            RowBox[{"data", ",", "\"\<ShiftJIS\>\""}], "]"}], ",", "2"}], 
          "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\:7d42\:7aefPattern", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:6f22\:5b57\:60c5\:5831\:8a9e", "[", "data_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Partition", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Partition", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", "\[IndentingNewLine]", 
         RowBox[{"Join", "[", 
          RowBox[{"\:6f22\:5b57Mode", ",", 
           RowBox[{"\:6587\:5b57\:6570", "[", 
            RowBox[{"data", ",", "\"\<\:6f22\:5b57\>\""}], "]"}], ",", 
           RowBox[{"\:6f22\:5b57Data", "[", "data", "]"}], ",", 
           "\:7d42\:7aefPattern"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
        "8", ",", "8", ",", "1", ",", "0"}], "]"}], ",", 
      "\[IndentingNewLine]", "9", ",", "9", ",", "1", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", "1", ",", "0", ",",
           "0"}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
         "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",",
           "1"}], "}"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:60c5\:5831\:591a\:9805\:5f0f", "[", "word_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"\:52a0\:6cd5\:8868\:793a", "[", 
        RowBox[{"#", ".", 
         RowBox[{"Table", "[", 
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            RowBox[{"(", 
             RowBox[{"7", "-", "i"}], ")"}]], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "0", ",", "7"}], "}"}]}], "]"}]}], "]"}], "&"}],
       ",", "word"}], "\[IndentingNewLine]", "]"}], ".", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"9", "-", "i"}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "9"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:7b26\:53f7\:591a\:9805\:5f0f", "[", "poly_", "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Collect", "[", 
    RowBox[{
     RowBox[{"PolynomialMod", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"poly", "*", 
         RowBox[{"x", "^", "17"}]}], "+", 
        RowBox[{"PolynomialRemainder", "[", 
         RowBox[{
          RowBox[{"poly", "*", 
           RowBox[{"x", "^", "17"}]}], ",", 
          RowBox[{"\:751f\:6210\:591a\:9805\:5f0f", "[", 
           RowBox[{"26", ",", "9"}], "]"}], ",", "x"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"\:751f\:6210\:5143", ",", "2"}], "}"}]}], "]"}], ",", "x"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:9001\:4fe1\:8a9e", "[", "poly_", "]"}], ":=", 
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Coefficient", "[", 
           RowBox[{
            RowBox[{"\:52a0\:6cd5\:8868\:793a", "[", "#", "]"}], ",", 
            "\[Gamma]", ",", 
            RowBox[{"7", "-", "i"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "0", ",", "7"}], "}"}]}], "]"}], " ", "&"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"poly", ",", "x", ",", 
           RowBox[{"25", "-", "i"}]}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"i", ",", "0", ",", "25"}], "}"}]}], "]"}]}], "]"}], ",", 
     "2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\:6f22\:5b57QRcode", "[", "moji_", "]"}], ":=", 
   RowBox[{"\:9001\:4fe1\:8a9e", "[", 
    RowBox[{"\:7b26\:53f7\:591a\:9805\:5f0f", "[", 
     RowBox[{"\:60c5\:5831\:591a\:9805\:5f0f", "[", 
      RowBox[{"\:6f22\:5b57\:60c5\:5831\:8a9e", "[", "moji", "]"}], "]"}], 
     "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.722077546995715*^9, {3.748234644023302*^9, 3.748234649100937*^9}, {
   3.748236181555641*^9, 3.748236183031871*^9}, {3.748236542474773*^9, 
   3.748236567321085*^9}, {3.748252275244068*^9, 3.748252376891498*^9}, {
   3.748307556542931*^9, 3.748307556870329*^9}, {3.748650154387142*^9, 
   3.7486501552269173`*^9}, {3.783298434904001*^9, 3.7832984435825777`*^9}, {
   3.783298475422412*^9, 3.783298483868539*^9}, {3.783298521830813*^9, 
   3.78329853402421*^9}, {3.7833008707280903`*^9, 3.78330092521212*^9}, {
   3.783301484621827*^9, 3.783301501308826*^9}, {3.7833016869649363`*^9, 
   3.783301694411375*^9}, {3.7833017304079313`*^9, 3.783301761409795*^9}, {
   3.7833018058895893`*^9, 3.783301806530428*^9}, {3.783302012407032*^9, 
   3.783302014817857*^9}, {3.783302283835287*^9, 3.783302334275179*^9}, {
   3.783302406871923*^9, 3.7833024135064793`*^9}, {3.783302449688167*^9, 
   3.783302462093561*^9}, {3.783302803290677*^9, 3.7833028882446833`*^9}, {
   3.783302948185473*^9, 3.783302958012514*^9}},
 Background->GrayLevel[0.85],
 CellLabel->"In[17]:=",ExpressionUUID->"b76be31e-e640-47cd-b798-7b82d1eaf111"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "\:6f22\:5b57\:60c5\:5831\:8a9e", "[", "\"\<\:8349\:91ce\:6e80\:4ee3\>\"", 
   "]"}], "//", "TableForm"}]], "Input",
 CellChangeTimes->{{3.748236442707165*^9, 3.748236472531723*^9}, {
  3.748236766259313*^9, 3.74823676837519*^9}, {3.748252445444997*^9, 
  3.748252466348406*^9}, {3.7483075595974894`*^9, 3.7483075599407597`*^9}, {
  3.7486501612660923`*^9, 3.748650161895681*^9}, {3.78330092824597*^9, 
  3.7833009671832314`*^9}, {3.783302350484091*^9, 3.783302358444125*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"681dc0a1-4d90-4654-ba5d-6955be81516d"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  RowBox[{
  "\:6f22\:5b57\:60c5\:5831\:8a9e", "[", "\"\<\:8349\:91ce\:6e80\:4ee3\>\"", 
   "]"}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Input",
 CellChangeTimes->{3.783309176623519*^9},
 CellLabel->"In[33]:=",ExpressionUUID->"0b1a11c6-9ffb-47e0-9c8b-948c02491435"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.783309176689374*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"8eaf3228-c0f9-4caa-9a75-04c11ef14a17"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ExportString", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{
         RowBox[{
         "\:6f22\:5b57QRcode", "[", "\"\<\:8349\:91ce\:6e80\:4ee3\>\"", "]"}],
          "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "26"}], "}"}]}], "]"}], ",", 
    "\"\<Table\>\""}], "]"}], "//", "TableForm"}]], "Input",
 CellChangeTimes->{{3.783301003086499*^9, 3.78330101453189*^9}, 
   3.783302367363562*^9},
 CellLabel->"In[34]:=",ExpressionUUID->"7c537ec8-9fb8-4e4a-a4d8-ac971fd8732c"],

Cell[BoxData[
 TagBox["\<\"1\\t{1, 0, 0, 0, 0, 0, 0, 0}\\n2\\t{0, 1, 0, 0, 0, 1, 1, \
0}\\n3\\t{0, 0, 1, 0, 1, 0, 0, 0}\\n4\\t{0, 1, 0, 0, 0, 0, 0, 1}\\n5\\t{1, 0, \
1, 1, 0, 0, 1, 0}\\n6\\t{0, 0, 0, 0, 0, 0, 1, 1}\\n7\\t{1, 1, 0, 0, 1, 1, 0, \
0}\\n8\\t{1, 0, 1, 0, 0, 0, 1, 1}\\n9\\t{0, 0, 0, 0, 0, 0, 0, 0}\\n10\\t{0, \
1, 1, 1, 0, 0, 0, 1}\\n11\\t{0, 1, 1, 0, 0, 0, 0, 1}\\n12\\t{1, 1, 0, 0, 1, \
1, 1, 1}\\n13\\t{1, 1, 0, 0, 0, 0, 1, 0}\\n14\\t{0, 1, 1, 1, 1, 0, 0, 0}\\n15\
\\t{1, 1, 1, 1, 1, 0, 0, 0}\\n16\\t{0, 1, 1, 0, 1, 0, 1, 0}\\n17\\t{1, 1, 0, \
1, 1, 0, 0, 0}\\n18\\t{0, 1, 0, 1, 1, 0, 1, 1}\\n19\\t{0, 0, 0, 1, 0, 0, 0, \
0}\\n20\\t{0, 0, 0, 1, 0, 1, 1, 0}\\n21\\t{0, 1, 0, 0, 0, 0, 1, 1}\\n22\\t{1, \
1, 0, 1, 0, 0, 1, 0}\\n23\\t{0, 0, 1, 0, 1, 1, 1, 1}\\n24\\t{1, 1, 0, 1, 1, \
1, 1, 1}\\n25\\t{1, 1, 1, 1, 0, 0, 1, 0}\\n26\\t{1, 0, 0, 1, 0, 0, 0, 0}\"\>",
  
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.783301021073656*^9, 3.78330152684282*^9, 
  3.78330236810394*^9, 3.7833024211992073`*^9, 3.783302471294161*^9, 
  3.783303387288488*^9, 3.7833091899296093`*^9},
 CellLabel->
  "Out[34]//TableForm=",ExpressionUUID->"be62810c-83bc-4cf8-97dd-\
6c52564805f9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"\:6f22\:5b57QRcode", "[", "\"\<\:725b\:8d8a\:9678\>\"", "]"}], 
      "[", 
      RowBox[{"[", "i", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "26"}], "}"}]}], "]"}], ",", 
   "\"\<TSV\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.7833010741426888`*^9, 3.7833010996135*^9}, {
  3.783301548036241*^9, 3.7833015525145082`*^9}, {3.783309152520227*^9, 
  3.783309160208778*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"8add2121-d9b3-4184-aa33-f7d838e04530"],

Cell[BoxData["\<\"1\\t0\\t0\\t0\\t0\\t0\\t0\\t0\\n0\\t0\\t1\\t1\\t0\\t0\\t1\\\
t1\\n1\\t1\\t1\\t0\\t0\\t1\\t1\\t0\\n1\\t0\\t0\\t1\\t1\\t0\\t0\\t0\\n1\\t1\\\
t1\\t0\\t1\\t0\\t1\\t0\\n0\\t0\\t0\\t1\\t1\\t1\\t0\\t0\\n1\\t0\\t0\\t0\\t0\\\
t0\\t0\\t0\\n0\\t0\\t0\\t1\\t0\\t0\\t0\\t1\\n1\\t1\\t1\\t0\\t1\\t1\\t0\\t0\\\
n1\\t1\\t0\\t0\\t1\\t1\\t0\\t0\\n1\\t1\\t0\\t0\\t0\\t1\\t1\\t0\\n1\\t1\\t1\\\
t1\\t1\\t0\\t0\\t0\\n1\\t1\\t0\\t1\\t0\\t1\\t1\\t0\\n0\\t1\\t1\\t1\\t0\\t0\\\
t0\\t0\\n1\\t1\\t1\\t0\\t1\\t0\\t1\\t1\\n1\\t0\\t0\\t1\\t0\\t1\\t0\\t0\\n1\\\
t0\\t1\\t0\\t0\\t1\\t1\\t1\\n1\\t0\\t0\\t0\\t1\\t1\\t0\\t1\\n1\\t0\\t0\\t1\\\
t1\\t0\\t1\\t0\\n1\\t1\\t1\\t0\\t0\\t0\\t1\\t0\\n1\\t1\\t1\\t0\\t1\\t0\\t1\\\
t1\\n0\\t0\\t0\\t1\\t1\\t0\\t0\\t0\\n0\\t0\\t0\\t1\\t0\\t1\\t0\\t1\\n1\\t0\\\
t1\\t1\\t0\\t1\\t1\\t1\\n0\\t1\\t0\\t1\\t1\\t0\\t1\\t1\\n0\\t0\\t1\\t1\\t0\\\
t1\\t0\\t1\\n\"\>"], "Output",
 CellChangeTimes->{{3.783301086856724*^9, 3.78330110190252*^9}, {
   3.783301531825615*^9, 3.783301554928131*^9}, 3.783302372615868*^9, 
   3.78330242660423*^9, 3.783303399627911*^9, 3.783309200068243*^9},
 CellLabel->"Out[35]=",ExpressionUUID->"dd8a199c-7cd3-4166-88c1-3fa98eb22aec"]
}, Open  ]]
},
WindowSize->{808, 755},
WindowMargins->{{Automatic, 43}, {Automatic, 0}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (2019\:5e745\:67083\:65e5)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 9270, 247, 1019, "Input",ExpressionUUID->"b76be31e-e640-47cd-b798-7b82d1eaf111"],
Cell[9831, 269, 592, 10, 46, "Input",ExpressionUUID->"681dc0a1-4d90-4654-ba5d-6955be81516d"],
Cell[CellGroupData[{
Cell[10448, 283, 304, 8, 33, InheritFromParent,ExpressionUUID->"0b1a11c6-9ffb-47e0-9c8b-948c02491435"],
Cell[10755, 293, 1344, 40, 77, "Output",ExpressionUUID->"8eaf3228-c0f9-4caa-9a75-04c11ef14a17"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12136, 338, 656, 18, 82, "Input",ExpressionUUID->"7c537ec8-9fb8-4e4a-a4d8-ac971fd8732c"],
Cell[12795, 358, 1216, 20, 571, "Output",ExpressionUUID->"be62810c-83bc-4cf8-97dd-6c52564805f9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14048, 383, 608, 15, 46, "Input",ExpressionUUID->"8add2121-d9b3-4184-aa33-f7d838e04530"],
Cell[14659, 400, 1174, 15, 615, "Output",ExpressionUUID->"dd8a199c-7cd3-4166-88c1-3fa98eb22aec"]
}, Open  ]]
}
]
*)

